# Cara Memperbaiki Login Admin

Jika login admin masih gagal, ikuti langkah berikut:

## 1. Hapus Data User Lama (Jika Ada)

Jalankan query SQL berikut di database Anda untuk menghapus user lama:

```sql
DELETE FROM users;
```

Atau gunakan command line:
```bash
php spark db:query "DELETE FROM users"
```

## 2. Jalankan Seeder Ulang

Seeder sudah diperbaiki untuk hash password dengan benar. Jalankan:

```bash
php spark db:seed UsersSeeder
```

## 3. Verifikasi Data User

Pastikan user sudah terbuat dengan password yang ter-hash:

```bash
php spark db:query "SELECT username, role, LEFT(password, 20) as password_preview FROM users"
```

Password seharusnya terlihat seperti hash (bukan plain text "admin123").

## 4. Coba Login

Gunakan kredensial berikut:
- **Admin Aktivitas**: username `admin_activities`, password `admin123`
- **Admin Biodata**: username `admin_biodata`, password `admin123`
- **Admin Pendidikan**: username `admin_education`, password `admin123`

## 5. Jika Masih Gagal

Jika masih gagal, cek:
1. Pastikan session sudah diaktifkan di `app/Config/App.php`
2. Pastikan database connection benar
3. Cek log error di `writable/logs/`

## Alternatif: Buat User Manual

Jika seeder masih bermasalah, buat user manual dengan query:

```sql
INSERT INTO users (username, email, password, role, created_at, updated_at) VALUES
('admin_activities', 'admin.activities@portfolio.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'admin_activities', NOW(), NOW()),
('admin_biodata', 'admin.biodata@portfolio.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'admin_biodata', NOW(), NOW()),
('admin_education', 'admin.education@portfolio.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'admin_education', NOW(), NOW());
```

Password hash di atas adalah untuk password: `admin123`


